#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Jun  4 18:30:55 2019

@author: aurelien
"""


import numpy as np
import matplotlib.pyplot as plt

from slmtools.gui import SLM
import sys
import glob
from tifffile import tifffile

sys.path.append("../..")

from constants import FIG_UNIT

def plot_scalebar(axis,npix,img):
    u,v = img.shape
    xpos = 0.7
    yops = .9
    sbarw = 3
    xlen = npix
    xsbar = np.linspace( xpos*v,(xpos)*v+xlen,20)
    ysbar = np.ones_like(xsbar)*u*yops
    axis.plot(xsbar,ysbar,color="white",linewidth = sbarw )
    
plt.close("all")
slm_main = SLM()
slm = slm_main.pupils[0]
slm_main.set_hologram_geometry([0,0,200,200])
slm.set_rho(100)
slm.set_mask2d_on(True)

arr2d = slm.refresh_pupil()
mval = arr2d.max()
# arr2d[slm.rho>1]=np.nan

slm.set_mask3d_radius(0.8)
slm.set_mask3d_on(True)
arrch08 = slm.refresh_pupil()

slm.set_mask3d_radius(0.9)
slm.set_mask3d_on(True)
arrch09 = slm.refresh_pupil()

def show_arr(arr,name):
    fig = plt.figure(figsize=(FIG_UNIT,FIG_UNIT))
    plt.imshow(arr,vmin=0,vmax=arr.max(),cmap="gray")
    plt.axis("off")
    fig.savefig(name+"_mask.svg",dpi = 600,transparent = True)
    
arrs = [arr2d,arrch08,arrch09]
names=["2D","CH08","C09"]

for j in range(len(arrs)):
    show_arr(arrs[j],names[j])

CROP = 2
files_tif = glob.glob("*.tif")
for file in files_tif:
    img = tifffile.imread(file)-2**15
    img = img[CROP:-CROP,CROP:-CROP]
    fig,ax = plt.subplots(1,1,figsize = (FIG_UNIT,FIG_UNIT))
    ax.imshow(img,cmap="magma")
    ax.axis("off")
    if "2D" in file:
        plot_scalebar(ax,10,img)
    fig.savefig(file.split(".")[0]+".svg",transparent=True)